<?php

namespace App\Models\Base;

use App\Models\Catalogs\Currency;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankMoveTemp
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string|null $key
 * @property string|null $date
 * @property string|null $reference
 * @property float $amount
 * @property int|null $currency_id
 * @property int|null $company_id
 * @property string|null $file_template
 * @property int|null $bank_reconciliation_line_temp_id
 * @property bool $status
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankMoveTempReconciled[] $bankMoveTempReconcileds
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereBankReconciliationLineTempId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereFileTemplate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTemp whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BankMoveTemp extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_move_temps';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'key',
        'date',
        'reference',
        'amount',
        'currency_id',
        'company_id',
        'file_template',
        'bank_reconciliation_line_temp_id',
        'status',
    ];

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function bankMoveTempReconcileds()
    {
        return $this->hasMany(BankMoveTempReconciled::class);
    }
}
