<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankMoveTempReconciled
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $bank_move_temp_id
 * @property int|null $reconciled_id
 * @property string|null $key
 * @property float $amount_reconciled
 * @property int|null $bank_reconciliation_line_temp_id
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Base\BankMoveTemp|null $bankMoveTemp
 * @property-read \App\Models\Base\CfdiDownload|null $reconciled
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereAmountReconciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereBankMoveTempId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereBankReconciliationLineTempId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereReconciledId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankMoveTempReconciled whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BankMoveTempReconciled extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_move_temp_reconcileds';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'bank_move_temp_id',
        'reconciled_id',
        'key',
        'amount_reconciled',
        'bank_reconciliation_line_temp_id',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function bankMoveTemp()
    {
        return $this->belongsTo(BankMoveTemp::class);
    }

    public function reconciled()
    {
        return $this->belongsTo(CfdiDownload::class,'reconciled_id','id');
    }
}
