<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankReconciliation
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string|null $name
 * @property string|null $file_template
 * @property int $status
 * @property int|null $company_id
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankReconciliationLine[] $bankReconciliationLines
 * @property-read \App\Models\Base\Company|null $company
 * @property-read mixed $status_name
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereFileTemplate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property string|null $key
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankReconciliationUnreconcile[] $bankReconciliationUnreconciles
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliation whereKey($value)
 */
class BankReconciliation extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_reconciliations';

    const PATH_FILES = 'files/bank_reconciliations';

    const DRAFT = 1; //Borrador
    const OPEN = 2; //Conciliado
    const CANCEL = 3; //Cancelado

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'file_template','company_id', 'status','key',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['created_at', 'name', 'file_template', 'status','key',];

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('created_at', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('created_at', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_status'])) {
                $status = $input['filter_status'];
                $query->where('status', '=', $status);
            }
        });

        return $query;
    }

    public function getStatusNameAttribute()
    {
        $status_name = '';
        if($this->status == BankReconciliation::DRAFT) {
            $status_name = __('base/bank_reconciliation.text_status_draft');
        }elseif($this->status == BankReconciliation::OPEN){
            $status_name = __('base/bank_reconciliation.text_status_open');
        }elseif($this->status == BankReconciliation::CANCEL){
            $status_name = __('base/bank_reconciliation.text_status_cancel');
        }
        return $status_name;
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function bankReconciliationLines()
    {
        return $this->hasMany(BankReconciliationLine::class)->where('status','=','1');
    }

    public function bankReconciliationUnreconciles()
    {
        return $this->hasMany(BankReconciliationUnreconcile::class)->where('status','=','1');
    }
}
