<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankReconciliationLine
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $bank_reconciliation_id
 * @property string|null $key
 * @property float $amount_reconciled
 * @property int|null $sort_order
 * @property bool $status
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankMoveReconciled[] $bankMoveReconcileds
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankMove[] $bankMoves
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereAmountReconciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereBankReconciliationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLine whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BankReconciliationLine extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_reconciliation_lines';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'bank_reconciliation_id',
        'key',
        'amount_reconciled',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function bankMoves()
    {
        return $this->hasMany(BankMove::class);
    }

    public function bankMoveReconcileds()
    {
        return $this->hasMany(BankMoveReconciled::class);
    }

    public function bankReconciliation()
    {
        return $this->belongsTo(BankReconciliation::class);
    }
}
