<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankReconciliationLineTemp
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string|null $key
 * @property float $amount_reconciled
 * @property int|null $sort_order
 * @property bool $status
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankMoveTempReconciled[] $bankMoveTempReconcileds
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankMoveTemp[] $bankMoveTemps
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereAmountReconciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationLineTemp whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BankReconciliationLineTemp extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_reconciliation_line_temps';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'key',
        'amount_reconciled',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function bankMoveTemps()
    {
        return $this->hasMany(BankMoveTemp::class);
    }

    public function bankMoveTempReconcileds()
    {
        return $this->hasMany(BankMoveTempReconciled::class);
    }
}
