<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\BankReconciliationUnreconcile
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $bank_reconciliation_id
 * @property int|null $cfdi_download_id
 * @property string|null $key
 * @property int|null $sort_order
 * @property bool $status
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\BankReconciliation[] $bankReconciliation
 * @property-read \App\Models\Base\CfdiDownload|null $cfdiDownload
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereBankReconciliationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereCfdiDownloadId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BankReconciliationUnreconcile whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BankReconciliationUnreconcile extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'bank_reconciliation_unreconciles';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'bank_reconciliation_id',
        'cfdi_download_id',
        'key',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }
    public function bankReconciliation()
    {
        return $this->hasMany(BankReconciliation::class);
    }
    public function cfdiDownload()
    {
        return $this->belongsTo(CfdiDownload::class);
    }
}
