<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class BlackListSat extends Model
{
    use Sortable,UsesSystemConnection;

    protected $table = 'black_list_sats';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_at',
        'updated_at',
        'created_uid',
        'updated_uid',
        'name',
        'taxid',
        'status_sat',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','taxid', 'status_sat', 'sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('status_sat', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }
}
