<?php

namespace App\Models\Base;

use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\State;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\BranchOffice
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $phone_mobile
 * @property string|null $address_1
 * @property string|null $address_2
 * @property string|null $address_3
 * @property string|null $address_4
 * @property string|null $address_5
 * @property string|null $address_6
 * @property int|null $city_id
 * @property int|null $state_id
 * @property int $country_id
 * @property string $postcode
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property int|null $company_id
 * @property-read \App\Models\Catalogs\City|null $city
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Country $country
 * @property-read \App\Models\Catalogs\State|null $state
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereAddress1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereAddress2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereAddress3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereAddress4($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereAddress5($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereAddress6($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereCityId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereCountryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice wherePhoneMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice wherePostcode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereStateId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\BranchOffice whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class BranchOffice extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'branch_offices';
    const PATH_LOGO_DOCS = 'images/branch_offices';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'email',
        'phone',
        'phone_mobile',
        'address_1',
        'address_2',
        'address_3',
        'address_4',
        'address_5',
        'address_6',
        'city_id',
        'state_id',
        'country_id',
        'postcode',
        'comment',
        'sort_order',
        'status',
        'company_id',
        'logo_docs'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','taxid','email','phone', 'sort_order', 'status'];

    /**
     * @return string
     */
    public function pathLogoDocs(){
        return '/app-images-company/'.$this->company_id.'/' . self::PATH_LOGO_DOCS . '/' . $this->logo_docs;
    }

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhereHas('country', function ($q) use ($search) {
                    $q->where('countries.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
            }
        });

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

}
