<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use App\Models\Catalogs\CfdiType;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\ExpenseType;
use App\Models\Catalogs\OperationalType;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentWay;
use App\Models\Sales\CustomerInvoiceCfdi;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\CfdiDownload
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $type
 * @property string|null $uuid
 * @property string|null $name
 * @property string|null $serie
 * @property int|null $folio
 * @property string|null $date
 * @property string|null $date_certification
 * @property string|null $rfc_emisor
 * @property string|null $emisor
 * @property string|null $rfc_receptor
 * @property string|null $receptor
 * @property int|null $payment_way_id
 * @property int|null $payment_method_id
 * @property int|null $cfdi_use_id
 * @property int|null $currency_id
 * @property float $currency_value
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property string|null $cfdi_type
 * @property string|null $status
 * @property string|null $is_cancelable
 * @property string|null $cancel_status
 * @property string|null $rfc_pac
 * @property string|null $file_xml
 * @property string|null $file_pdf
 * @property string|null $comment
 * @property-read \App\Models\Catalogs\CfdiType $cfdiType
 * @property-read \App\Models\Catalogs\CfdiUse|null $cfdiUse
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Catalogs\PaymentMethod|null $paymentMethod
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload filter($input = [])
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCancelStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCfdiType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCfdiUseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereDateCertification($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereEmisor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereFilePdf($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereFileXml($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereIsCancelable($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload wherePaymentMethodId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereReceptor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereRfcEmisor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereRfcPac($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereRfcReceptor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereSerie($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereUuid($value)
 * @mixin \Eloquent
 * @property string|null $file_acuse
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereFileAcuse($value)
 * @property int|null $cfdi_type_id
 * @property int|null $company_id
 * @property-read \App\Models\Base\Company|null $company
 * @property-read mixed $type_name
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCfdiTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereCompanyId($value)
 * @property int|null $expense_type_id
 * @property string|null $date_payment
 * @property-read \App\Models\Catalogs\ExpenseType|null $expenseType
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereDatePayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereExpenseTypeId($value)
 * @property float $balance
 * @property int|null $operational_type_id
 * @property string|null $comment_2
 * @property bool $conciled
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\CfdiDownloadPayment[] $cfdiDownloadPayments
 * @property-read \App\Models\Catalogs\OperationalType|null $operationalType
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload totalDashboard($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereComment2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereConciled($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownload whereOperationalTypeId($value)
 */
class CfdiDownload extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'cfdi_downloads';

    const PATH_FILES = 'files/cfdi_downloads';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'type',
        'uuid',
        'name',
        'serie',
        'folio',
        'date',
        'date_certification',
        'rfc_emisor',
        'emisor',
        'rfc_receptor',
        'receptor',
        'payment_way_id',
        'payment_method_id',
        'cfdi_use_id',
        'currency_id',
        'currency_value',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'cfdi_type_id',
        'status',
        'is_cancelable',
        'cancel_status',
        'rfc_pac',
        'file_xml',
        'file_pdf',
        'file_acuse',
        'company_id',
        'comment',
        'expense_type_id',
        'date_payment',
        'balance',
        'operational_type_id',
        'comment_2',
        'conciled',
        'date_cancel'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'uuid',
        'name',
        'date',
        'date_certification',
        'amount_untaxed',
        'amount_total',
        'rfc_emisor',
        'emisor',
        'rfc_receptor',
        'receptor'
    ];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('cfdi_downloads.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
            if (!empty($input['filter_name'])) {
                $name = $input['filter_name'];
                $query->where(function ($query) use ($name) {
                    $query->where('name', 'like', '%' . str_replace(' ', '%%', $name) . '%');
                    $query->orWhere('uuid', 'like', '%' . str_replace(' ', '%%', $name) . '%');
                });
            }
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('date', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('date', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_emisor'])) {
                $emisor = $input['filter_emisor'];
                $query->where(function ($query) use ($emisor) {
                    $query->where('emisor', 'like', '%' . str_replace(' ', '%%', $emisor) . '%');
                    $query->orWhere('rfc_emisor', 'like', '%' . str_replace(' ', '%%', $emisor) . '%');
                });
            }
            if (!empty($input['filter_receptor'])) {
                $receptor = $input['filter_receptor'];
                $query->where(function ($query) use ($receptor) {
                    $query->where('receptor', 'like', '%' . str_replace(' ', '%%', $receptor) . '%');
                    $query->orWhere('rfc_receptor', 'like', '%' . str_replace(' ', '%%', $receptor) . '%');
                });
            }
            if (!empty($input['filter_type'])) {
                $query->where('type', '=', $input['filter_type']);
            }
            if (!empty($input['filter_cfdi_type_id'])) {
                $query->where('cfdi_type_id', '=', $input['filter_cfdi_type_id']);
            }
            if (!empty($input['filter_status'])) {
                $query->where('status', '=', $input['filter_status']);
            }
        });

        return $query;
    }

    public function scopeTotalDashboard($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function ($query) use ($input) {
            $query->whereIn('status', ['Vigente']);
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('date', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('date', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_cfdi_type'])) {
                $query->whereHas('cfdiType', function ($q) use ($input) {
                    if(is_array($input['filter_cfdi_type'])){
                        $q->whereIn('cfdi_types.code', $input['filter_cfdi_type']);
                    }else {
                        $q->where('cfdi_types.code', '=', $input['filter_cfdi_type']);
                    }
                });
            }
            if (!empty($input['filter_type'])) {
                $query->where('type', '=', $input['filter_type']);
            }
        });

        return $query;
    }

    public function getTypeNameAttribute()
    {
        return $this->type == 1 ? __('base/cfdi_download.tab_received') : ($this->type == 2 ? __('base/cfdi_download.tab_issued') : '');
    }

    public function getFileXmlExistsAttribute(){
        $path_files = Helper::setDirectory(self::PATH_FILES, $this->company_id) . '/';
        if(empty($this->file_xml))
            return false;

        return \Storage::exists($path_files . $this->file_xml);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function cfdiUse()
    {
        return $this->belongsTo(CfdiUse::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function cfdiType()
    {
        return $this->belongsTo(CfdiType::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function expenseType()
    {
        return $this->belongsTo(ExpenseType::class);
    }

    public function cfdiDownloadPayments()
    {
        return $this->hasMany(CfdiDownloadPayment::class)->where('status','=','1');
    }

    public function operationalType()
    {
        return $this->belongsTo(OperationalType::class);
    }

    public function blackListSatEmisor()
    {
        return $this->belongsTo(BlackListSat::class,'rfc_emisor','taxid');
    }

    public function blackListSatReceptor()
    {
        return $this->belongsTo(BlackListSat::class,'rfc_receptor','taxid');
    }

    public function bankMoveReconcileds()
    {
        return $this->hasMany(BankMoveReconciled::class,'reconciled_id');
    }

    public function customerInvoiceCfdi()
    {
        return $this->belongsTo(CustomerInvoiceCfdi::class,'uuid','uuid');
    }


}
