<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use App\Models\Catalogs\PaymentWay;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\Currency;

/**
 * App\Models\Base\CfdiDownloadPayment
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $cfdi_download_id
 * @property int|null $currency_id
 * @property float|null $currency_value
 * @property string|null $date_payment
 * @property float $amount_payment
 * @property string|null $reference
 * @property int $sort_order
 * @property bool $status
 * @property int|null $payment_way_id
 * @property-read \App\Models\Base\CfdiDownload $cfdiDownload
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereAmountPayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereCfdiDownloadId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereDatePayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CfdiDownloadPayment whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CfdiDownloadPayment extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'cfdi_download_payments';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'cfdi_download_id',
        'currency_id',
        'currency_value',
        'date_payment',
        'amount_payment',
        'reference',
        'sort_order',
        'status',
        'payment_way_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['date_payment','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];

        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function cfdiDownload()
    {
        return $this->belongsTo(CfdiDownload::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }
}
