<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class CfdiDownloadRequestFile extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'cfdi_download_request_files';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'cfdi_download_request_id',
        'folio_download',
        'folio_download_metadata',
        'file',
        'file_metadata',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'id',
    ];

    public function cfdiDownloadRequest()
    {
        return $this->belongsTo(CfdiDownloadRequest::class);
    }
}
