<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\State;
use App\Models\Catalogs\TaxRegimen;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\Company
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $image
 * @property string $taxid
 * @property int|null $tax_regimen_id
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $phone_mobile
 * @property string|null $address_1
 * @property string|null $address_2
 * @property string|null $address_3
 * @property string|null $address_4
 * @property string|null $address_5
 * @property string|null $address_6
 * @property int|null $city_id
 * @property int|null $state_id
 * @property int $country_id
 * @property string $postcode
 * @property string|null $file_cer
 * @property string|null $file_key
 * @property string|null $password_key
 * @property string|null $file_pfx
 * @property string|null $certificate_number
 * @property string|null $date_start
 * @property string|null $date_end
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property string|null $color_primary
 * @property string|null $product_price_decimal_place
 * @property string|null $pdf_template
 * @property string|null $complemento_cfdi_iedu
 * @property string|null $curp
 * @property string|null $complemento_cfdi_foreign_trade
 * @property string|null $employer_register
 * @property string|null $module_customer_quotations
 * @property string|null $modulecq_terms_of_sale
 * @property string|null $module_payroll
 * @property string|null $modulepayr_legend
 * @property-read \App\Models\Catalogs\City|null $city
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\CompanyBankAccount[] $companyActiveBankAccounts
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\CompanyBankAccount[] $companyBankAccounts
 * @property-read \App\Models\Catalogs\Country $country
 * @property-read \App\Models\Catalogs\State|null $state
 * @property-read \App\Models\Catalogs\TaxRegimen|null $taxRegimen
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereAddress1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereAddress2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereAddress3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereAddress4($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereAddress5($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereAddress6($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereCertificateNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereCityId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereColorPrimary($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereComplementoCfdiForeignTrade($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereComplementoCfdiIedu($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereCountryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereCurp($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereDateEnd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereDateStart($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereEmployerRegister($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereFileCer($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereFileKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereFilePfx($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereModuleCustomerQuotations($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereModulePayroll($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereModulecqTermsOfSale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereModulepayrLegend($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company wherePasswordKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company wherePdfTemplate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company wherePhoneMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company wherePostcode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereProductPriceDecimalPlace($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereStateId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereTaxRegimenId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property string|null $titular
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Company whereTitular($value)
 */
class Company extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'companies';

    const PATH_IMAGES = 'images/companies';
    const PATH_FILES = 'files/companies';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'image',
        'taxid',
        'tax_regimen_id',
        'email',
        'phone',
        'phone_mobile',
        'address_1',
        'address_2',
        'address_3',
        'address_4',
        'address_5',
        'address_6',
        'city_id',
        'state_id',
        'country_id',
        'postcode',
        'file_cer',
        'file_key',
        'password_key',
        'file_pfx',
        'certificate_number',
        'date_start',
        'date_end',
        'comment',
        'sort_order',
        'status',
        'color_primary',
        'product_price_decimal_place',
        'pdf_template',
        'complemento_cfdi_iedu',
        'curp',
        'complemento_cfdi_foreign_trade',
        'employer_register',
        'module_customer_quotations',
        'module_customer_remissions',
        'modulecq_terms_of_sale',
        'module_payroll',
        'modulepayr_legend',
        'titular',
        'fiel_file_cer',
        'fiel_file_key',
        'fiel_password_key',
        'fiel_file_pfx',
        'fiel_certificate_number',
        'fiel_date_start',
        'fiel_date_end',
        'comercial_name',
        'tax_regimen_id2',
        'path_files'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'comercial_name', 'taxid','email','phone', 'sort_order', 'status'];

    /**
     * @return string
     */
    public function pathImage(){
        return '/app-images-company/'.$this->id.'/' . self::PATH_IMAGES . '/' . $this->image;
    }

    /**
     * @return string
     */
    public function pathFileCer(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . str_replace('.pem', '', $this->file_cer);
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFileCerPem(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . $this->file_cer;
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFileKey(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . str_replace('.pass.pem', '', $this->file_key);
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFileKeyPem(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . str_replace('.pass.pem', '.pem', $this->file_key);
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFileKeyPassPem(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . $this->file_key;
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFilePfx(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . $this->file_pfx;
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFielFileCer(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . $this->fiel_file_cer;
        return $tmp;
    }

    /**
     * @return string
     */
    public function pathFielFileKey(){
        $tmp = Helper::setDirectory(self::PATH_FILES,$this->id). '/' . $this->fiel_file_key;
        return $tmp;
    }

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('comercial_name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhereHas('taxRegimen', function ($q) use ($search) {
                $q->where('tax_regimens.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
            $query->orWhereHas('taxRegimen2', function ($q) use ($search) {
                $q->where('tax_regimens.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
            $query->orWhereHas('country', function ($q) use ($search) {
                $q->where('countries.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
        }

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getNameShortAttribute()
    {
        return str_limit($this->name, 25);
    }

    public function getComercialNameShortAttribute()
    {
        return str_limit($this->comercial_name, 10);
    }

    public function taxRegimen()
    {
        return $this->belongsTo(TaxRegimen::class);
    }

    public function taxRegimen2()
    {
        return $this->belongsTo(TaxRegimen::class,'tax_regimen_id2');
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function companyBankAccounts()
    {
        return $this->hasMany(CompanyBankAccount::class);
    }

    public function companyActiveBankAccounts()
    {
        return $this->hasMany(CompanyBankAccount::class)->where('status','=','1');
    }


}
