<?php

namespace App\Models\Base;

use App\Models\Catalogs\Bank;
use App\Models\Catalogs\Currency;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\CompanyBankAccount
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $company_id
 * @property string $name
 * @property string $account_number
 * @property int $bank_id
 * @property int $currency_id
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Catalogs\Bank $bank
 * @property-read \App\Models\Base\Company $company
 * @property-read \App\Models\Catalogs\Currency $currency
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereAccountNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereBankId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\CompanyBankAccount whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CompanyBankAccount extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'company_bank_accounts';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'company_id',
        'name',
        'account_number',
        'bank_id',
        'currency_id',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','account_number','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('company_bank_accounts.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('account_number', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
        });

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('company_bank_accounts.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
}
