<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

class Diot extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'diots';

    const PATH_FILES = 'files/diots';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'date',
        'month',
        'year',
        'file',
        'company_id',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'name',
        'date',
        'month',
        'year',
        'status'
    ];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('diots.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
            if (!empty($input['filter_name'])) {
                $name = $input['filter_name'];
                $query->where('name', 'like', '%' . str_replace(' ', '%%', $name) . '%');
            }
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('date', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('date', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_status'])) {
                $status = $input['filter_status'];
                $query->where('status', '=', $status);
            }
        });

        return $query;
    }

    public function diotLines()
    {
        return $this->hasMany(DiotLine::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
