<?php

namespace App\Models\Base;

use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

class DiotLine extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'diot_lines';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'diot_id',
        'cfdi_download_id',
        'customer_type',
        'operation_type',
        'taxid',
        'numid',
        'name',
        'foreign_country_code',
        'foreign_nationality',
        'iva_15_16',
        'iva_15',
        'iva_15_16_not',
        'iva_10_11',
        'iva_10',
        'border_stimulation',
        'iva_10_11_not',
        'border_stimulation_not',
        'foreign_iva_15_16',
        'foreign_iva_15_16_not',
        'foreign_iva_10_11',
        'foreign_iva_10_11_not',
        'foreign_exempt',
        'iva_0',
        'exempt',
        'iva_detained',
        'iva_dev_dis_bon',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['taxid','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function diot()
    {
        return $this->belongsTo(Diot::class);
    }

    public function cfdiDownload()
    {
        return $this->belongsTo(CfdiDownload::class);
    }
}
