<?php

namespace App\Models\Base;

use App\Models\Catalogs\Bank;
use App\Models\Catalogs\ContractType;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\FrequencyPayment;
use App\Models\Catalogs\JobRiskClasse;
use App\Models\Catalogs\RecruitmentRegime;
use App\Models\Catalogs\State;
use App\Models\Catalogs\WorkdayType;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\TaxRegimen;

/**
 * App\Models\Base\Employee
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property string|null $taxid
 * @property string|null $curp
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $phone_mobile
 * @property int|null $recruitment_regime_id
 * @property string|null $date_start_work
 * @property string|null $nss
 * @property bool $unionized
 * @property int|null $workday_type_id
 * @property int|null $contract_type_id
 * @property string|null $department
 * @property string|null $job
 * @property int|null $job_risk_classe_id
 * @property int|null $frequency_payment_id
 * @property int|null $bank_id
 * @property string|null $bank_account
 * @property float $base_salary
 * @property float $sdi
 * @property int|null $country_id
 * @property int|null $state_id
 * @property int|null $company_id
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property string|null $firstname
 * @property string|null $lastname
 * @property string|null $lastname2
 * @property int|null $employee_category_id
 * @property-read \App\Models\Catalogs\Bank|null $bank
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\ContractType|null $contractType
 * @property-read \App\Models\Catalogs\Country|null $country
 * @property-read \App\Models\Base\EmployeeCategory|null $employeeCategory
 * @property-read \App\Models\Catalogs\FrequencyPayment|null $frequencyPayment
 * @property-read mixed $description_select2
 * @property-read mixed $text_select2
 * @property-read \App\Models\Catalogs\JobRiskClasse|null $jobRiskClasse
 * @property-read \App\Models\Catalogs\RecruitmentRegime|null $recruitmentRegime
 * @property-read \App\Models\Catalogs\State|null $state
 * @property-read \App\Models\Catalogs\WorkdayType|null $workdayType
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereBankAccount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereBankId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereBaseSalary($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereContractTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereCountryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereCurp($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereDateStartWork($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereDepartment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereEmployeeCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereFirstname($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereFrequencyPaymentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereJob($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereJobRiskClasseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereLastname($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereLastname2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereNss($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee wherePhoneMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereRecruitmentRegimeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereSdi($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereStateId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereUnionized($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Employee whereWorkdayTypeId($value)
 * @mixin \Eloquent
 */
class Employee extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'employees';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'taxid',
        'curp',
        'email',
        'phone',
        'phone_mobile',
        'recruitment_regime_id',
        'date_start_work',
        'nss',
        'unionized',
        'workday_type_id',
        'contract_type_id',
        'department',
        'job',
        'job_risk_classe_id',
        'frequency_payment_id',
        'bank_id',
        'bank_account',
        'base_salary',
        'sdi',
        'country_id',
        'state_id',
        'company_id',
        'comment',
        'sort_order',
        'status',
        'firstname',
        'lastname',
        'lastname2',
        'employee_category_id',
        'postcode',
        'tax_regimen_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['code','name','taxid','email','phone', 'curp','nss','date_start_work','department','job', 'sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('employees.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('department', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('job', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('curp', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhereHas('frequencyPayment', function ($q) use ($search) {
                    $q->where('frequency_payments.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('recruitmentRegime', function ($q) use ($search) {
                    $q->where('recruitment_regimes.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('employeeCategory', function ($q) use ($search) {
                    $q->where('employee_categories.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
            }

            if (!empty($input['filter_employee_category_id'])) {
                $employee_category_id = $input['filter_employee_category_id'];
                $query->where('employee_category_id', '=', $employee_category_id);
            }

            if (!empty($input['filter_search_select2'])) {
                $search = $input['filter_search_select2'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('department', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('job', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('curp', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
        });

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return $this->name;
    }

    public function recruitmentRegime()
    {
        return $this->belongsTo(RecruitmentRegime::class);
    }

    public function workdayType()
    {
        return $this->belongsTo(WorkdayType::class);
    }

    public function contractType()
    {
        return $this->belongsTo(ContractType::class);
    }

    public function jobRiskClasse()
    {
        return $this->belongsTo(JobRiskClasse::class);
    }

    public function frequencyPayment()
    {
        return $this->belongsTo(FrequencyPayment::class);
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function employeeCategory()
    {
        return $this->belongsTo(EmployeeCategory::class);
    }
    public function taxRegimen()
    {
        return $this->belongsTo(TaxRegimen::class);
    }
}
