<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\EmployeeCategory
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int $sort_order
 * @property bool $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeeCategory whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class EmployeeCategory extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'employee_categories';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }
}
