<?php

namespace App\Models\Base;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Project;
use App\Models\Base\BranchOffice;
use App\Models\Base\DocumentType;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\TaxRegimen;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\PayrollType;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\SourceResource;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\EmployeePayroll
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $serie
 * @property int|null $folio
 * @property string|null $date
 * @property string|null $date_payment
 * @property string|null $date_start_payment
 * @property string|null $date_end_payment
 * @property string|null $reference
 * @property int|null $employee_id
 * @property int|null $payroll_type_id
 * @property int|null $branch_office_id
 * @property int|null $payment_way_id
 * @property int|null $payment_method_id
 * @property int|null $cfdi_use_id
 * @property int|null $currency_id
 * @property float $currency_value
 * @property float $base_salary
 * @property float $sdi
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_isr
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property float $amount_perceptions
 * @property float $amount_deductions
 * @property float $amount_other_payment_types
 * @property int|null $document_type_id
 * @property int|null $cfdi_relation_id
 * @property string|null $comment
 * @property bool $mail_sent
 * @property string|null $draft
 * @property int|null $company_id
 * @property int $payment_days
 * @property int $sort_order
 * @property bool $status
 * @property int|null $payroll_id
 * @property string|null $taxid_origin
 * @property float $rt_amount_an_exhibition
 * @property float $rt_partiality_amount
 * @property float $rt_daily_amount
 * @property float $rt_cumulative_income
 * @property float $rt_non_cumulative_income
 * @property float $sp_total_amount
 * @property float $sp_years_of_service
 * @property float $sp_last_salary
 * @property float $sp_cumulative_income
 * @property float $sp_non_cumulative_income
 * @property-read \App\Models\Base\BranchOffice|null $branchOffice
 * @property-read \App\Models\Catalogs\CfdiRelation|null $cfdiRelation
 * @property-read \App\Models\Catalogs\CfdiUse|null $cfdiUse
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Base\DocumentType|null $documentType
 * @property-read \App\Models\Base\Employee|null $employee
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActiveDeductions1PayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActiveDeductions2PayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActiveDeductionsPayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActiveDisabilitiesPayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActiveOtherPaymentTypesPayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollOutsourcing[] $employeeActivePayrollOutsourcings
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePerceptions1PayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePerceptions2PayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePerceptions3PayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePerceptions4PayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePerceptionsAllPayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeeActivePerceptionsPayrollLines
 * @property-read \App\Models\Base\EmployeePayrollCfdi $employeePayrollCfdi
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollLine[] $employeePayrollLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Base\EmployeePayrollRelation[] $employeePayrollRelations
 * @property-read mixed $description_select2
 * @property-read mixed $text_select2
 * @property-read \App\Models\Catalogs\PaymentMethod|null $paymentMethod
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @property-read \App\Models\Base\Payroll|null $payroll
 * @property-read \App\Models\Catalogs\PayrollType|null $payrollType
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll totalDashboard($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountDeductions($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountIsr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountOtherPaymentTypes($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountPerceptions($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereBaseSalary($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereBranchOfficeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCfdiRelationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCfdiUseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereDateEndPayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereDatePayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereDateStartPayment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereDocumentTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereDraft($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereEmployeeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereMailSent($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll wherePaymentDays($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll wherePaymentMethodId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll wherePayrollId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll wherePayrollTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereRtAmountAnExhibition($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereRtCumulativeIncome($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereRtDailyAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereRtNonCumulativeIncome($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereRtPartialityAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSdi($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSerie($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSpCumulativeIncome($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSpLastSalary($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSpNonCumulativeIncome($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSpTotalAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereSpYearsOfService($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereTaxidOrigin($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayroll whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property-read \App\Models\Catalogs\Project $project
 */
class EmployeePayroll extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'employee_payrolls';

    const PATH_XML_FILES = 'files/employee_payrolls/xml';

    //Por timbrar
    const DRAFT = 1;
    const OPEN = 2; //Timbrado
    const CANCEL = 3; //Cancelado


    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'serie',
        'folio',
        'date',
        'date_payment',
        'date_start_payment',
        'date_end_payment',
        'reference',
        'employee_id',
        'payroll_type_id',
        'branch_office_id',
        'payment_way_id',
        'payment_method_id',
        'cfdi_use_id',
        'currency_id',
        'currency_value',
        'base_salary',
        'sdi',
        'amount_discount',
        'amount_untaxed',
        'amount_isr',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'amount_perceptions',
        'amount_deductions',
        'amount_other_payment_types',
        'document_type_id',
        'cfdi_relation_id',
        'comment',
        'mail_sent',
        'draft',
        'company_id',
        'payment_days',
        'sort_order',
        'status',
        'payroll_id',
        'taxid_origin',
        'rt_amount_an_exhibition',
        'rt_partiality_amount',
        'rt_daily_amount',
        'rt_cumulative_income',
        'rt_non_cumulative_income',
        'sp_total_amount',
        'sp_years_of_service',
        'sp_last_salary',
        'sp_cumulative_income',
        'sp_non_cumulative_income',
        'source_resource_id',
        'sncf_amount_source_resource',
        'tax_regimen_id',
        'tax_regimen_employee_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'name',
        'date',
        'date_payment',
        'amount_untaxed',
        'amount_total',
        'mail_sent',
        'sort_order',
        'status'
    ];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('employee_payrolls.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
            if (!empty($input['filter_document_type_code'])) {
                $filter_document_type_code = $input['filter_document_type_code'];
                $query->WhereHas('documentType', function ($q) use ($filter_document_type_code) {
                    if(is_array($filter_document_type_code)){
                        $q->whereIn('document_types.code', $filter_document_type_code);
                    }else {
                        $q->where('document_types.code', '=', $filter_document_type_code);
                    }
                });
            }
            if (!empty($input['filter_name'])) {
                $name = $input['filter_name'];
                $query->where('name', 'like', '%' . str_replace(' ', '%%', $name) . '%');
            }
            if (!empty($input['filter_date_payment_from'])) {
                $query->whereDate('date_payment', '>=', Helper::convertDateToSql($input['filter_date_payment_from']));
            }
            if (!empty($input['filter_date_payment_to'])) {
                $query->whereDate('date_payment', '<=', Helper::convertDateToSql($input['filter_date_payment_to']));
            }
            if (!empty($input['filter_payroll_type_id'])) {
                $payroll_type_id = $input['filter_payroll_type_id'];
                $query->where('payroll_type_id', '=', $payroll_type_id);
            }
            if (!empty($input['filter_payment_way_id'])) {
                $payment_way_id = $input['filter_payment_way_id'];
                $query->where('payment_way_id', '=', $payment_way_id);
            }
            if (!empty($input['filter_employee_id'])) {
                $employee_id = $input['filter_employee_id'];
                $query->where('employee_id', '=', $employee_id);
            }
            if (!empty($input['filter_currency_id'])) {
                $currency_id = $input['filter_currency_id'];
                $query->where('currency_id', '=', $currency_id);
            }
            if (!empty($input['filter_branch_office_id'])) {
                $branch_office_id = $input['filter_branch_office_id'];
                $query->where('branch_office_id', '=', $branch_office_id);
            }
            if (!empty($input['filter_payroll_id'])) {
                $payroll_id = $input['filter_payroll_id'];
                $query->where('payroll_id', '=', $payroll_id);
            }
            if (!empty($input['filter_status'])) {
                $status = $input['filter_status'];
                $query->where('status', '=', $status);
            }
            if (!empty($input['filter_search_cfdi_select2'])) {
                $search = $input['filter_search_cfdi_select2'];
                //agregar los estatus y que tengan UUID para buscar
                $query->whereIn('status', [self::OPEN, self::CANCEL])
                    ->whereHas('employeePayrollCfdi', function ($q) {
                        $q->where('employee_payroll_cfdis.uuid', '<>', '');
                    })
                    ->where(function ($q) use ($search) {
                        $q->where('name', 'like', '%' . str_replace(' ', '%%', $search) . '%')
                            ->orWhereHas('employeePayrollCfdi', function ($q) use ($search) {
                                $q->where('employee_payroll_cfdis.uuid', 'like',
                                    '%' . str_replace(' ', '%%', $search) . '%');
                            });
                    });
            }
        });

        return $query;
    }

    public function scopeTotalDashboard($query, array $input = []){

        $query->where(function ($query) {
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            $query->whereIn('status', [self::OPEN]);
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('date', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('date', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_document_type_code'])) {
                $filter_document_type_code = $input['filter_document_type_code'];
                $query->WhereHas('documentType', function ($q) use ($filter_document_type_code) {
                    $q->where('document_types.code', '=', $filter_document_type_code);
                });
            }
        });

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return $this->name;
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function payrollType()
    {
        return $this->belongsTo(PayrollType::class);
    }

    public function branchOffice()
    {
        return $this->belongsTo(BranchOffice::class);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function cfdiUse()
    {
        return $this->belongsTo(CfdiUse::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function documentType()
    {
        return $this->belongsTo(DocumentType::class);
    }

    public function cfdiRelation()
    {
        return $this->belongsTo(CfdiRelation::class);
    }

    public function employeePayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class);
    }

    public function employeeActivePayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1');
    }

    public function employeeActivePerceptionsPayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('perception_id');
    }

    public function employeeActivePerceptions1PayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('perception_id')
            ->whereHas('perception', function ($q) {
                $q->whereNotIn('perceptions.code', ['022','023','025','039','044']);
            });
    }

    public function employeeActivePerceptions2PayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('perception_id')
            ->whereHas('perception', function ($q) {
                $q->whereIn('perceptions.code', ['022','023','025']);
            });
    }

    public function employeeActivePerceptions3PayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('perception_id')
            ->whereHas('perception', function ($q) {
                $q->whereIn('perceptions.code', ['039','044']);
            });
    }

    public function employeeActivePerceptions4PayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('perception_id')
            ->whereHas('perception', function ($q) {
                $q->whereIn('perceptions.code', ['046']);
            });
    }

    public function employeeActivePerceptionsAllPayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNull('deduction_id')->whereNull('disability_type_id');
    }

    public function employeeActiveDeductionsPayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('deduction_id');
    }

    public function employeeActiveDeductions1PayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('deduction_id')
            ->whereHas('deduction', function ($q) {
                $q->whereNotIn('deductions.code', ['002']);
            });
    }

    public function employeeActiveDeductions2PayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('deduction_id')
            ->whereHas('deduction', function ($q) {
                $q->whereIn('deductions.code', ['002']);
            });
    }

    public function employeeActiveOtherPaymentTypesPayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('other_payment_type_id');
    }

    public function employeeActiveDisabilitiesPayrollLines()
    {
        return $this->hasMany(EmployeePayrollLine::class)->where('status','=','1')->whereNotNull('disability_type_id');
    }

    public function employeeActivePayrollOutsourcings()
    {
        return $this->hasMany(EmployeePayrollOutsourcing::class)->where('status','=','1');
    }

    public function employeePayrollRelations()
    {
        return $this->hasMany(EmployeePayrollRelation::class);
    }

    public function employeePayrollCfdi()
    {
        return $this->hasOne(EmployeePayrollCfdi::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function sourceResource()
    {
        return $this->belongsTo(SourceResource::class);
    }

    public function taxRegimen()
    {
        return $this->belongsTo(TaxRegimen::class);
    }

    public function taxRegimenEmployee()
    {
        return $this->belongsTo(TaxRegimen::class, 'tax_regimen_employee_id');
    }
}
