<?php

namespace App\Models\Base;

use App\Models\Base\Pac;
use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Model;
use App\Models\Catalogs\ReasonCancellation;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\EmployeePayrollCfdi
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $employee_payroll_id
 * @property string $name
 * @property int|null $pac_id
 * @property string|null $cfdi_version
 * @property string|null $uuid
 * @property string|null $date
 * @property string|null $file_xml
 * @property string|null $file_xml_pac
 * @property string|null $cancel_date
 * @property string|null $cancel_response
 * @property string|null $cancel_state
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Base\EmployeePayroll $employeePayroll
 * @property-read \App\Models\Base\Pac|null $pac
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereCancelDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereCancelResponse($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereCancelState($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereCfdiVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereEmployeePayrollId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereFileXml($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereFileXmlPac($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi wherePacId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollCfdi whereUuid($value)
 * @mixin \Eloquent
 */
class EmployeePayrollCfdi extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'employee_payroll_cfdis';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'employee_payroll_id',
        'name',
        'pac_id',
        'cfdi_version',
        'uuid',
        'date',
        'file_xml',
        'file_xml_pac',
        'cancel_date',
        'cancel_response',
        'cancel_state',
        'status',
        'reason_cancellation_id',
        'reason_cancellation_uuid'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('uuid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function employeePayroll()
    {
        return $this->belongsTo(EmployeePayroll::class);
    }

    public function pac()
    {
        return $this->belongsTo(Pac::class);
    }

    public function reasonCancellation()
    {
        return $this->belongsTo(ReasonCancellation::class);
    }
}
