<?php

namespace App\Models\Base;

use App\Models\Catalogs\Deduction;
use App\Models\Catalogs\DisabilityType;
use App\Models\Catalogs\OtherPaymentType;
use App\Models\Catalogs\OvertimesType;
use App\Models\Catalogs\Perception;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\EmployeePayrollLine
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $employee_payroll_id
 * @property string|null $name
 * @property string|null $code
 * @property int|null $perception_id
 * @property int|null $deduction_id
 * @property int|null $other_payment_type_id
 * @property float $amount_taxed
 * @property float $amount_exempt
 * @property float $amount_total
 * @property float $amount_caused
 * @property int $sort_order
 * @property bool $status
 * @property float $ac_market_value
 * @property float $ac_price_when_granted
 * @property int $hr_days_1
 * @property int|null $hr_overtimes_type_id_1
 * @property int $hr_hours_1
 * @property float $hr_amount_paid_1
 * @property int $hr_days_2
 * @property int|null $hr_overtimes_type_id_2
 * @property int $hr_hours_2
 * @property float $hr_amount_paid_2
 * @property int $hr_days_3
 * @property int|null $hr_overtimes_type_id_3
 * @property int $hr_hours_3
 * @property float $hr_amount_paid_3
 * @property float $cm_positive_balance
 * @property int $cm_year
 * @property float $cm_remainder
 * @property int|null $disability_type_id
 * @property int $disability_days
 * @property float $disability_amount
 * @property-read \App\Models\Catalogs\Deduction|null $deduction
 * @property-read \App\Models\Catalogs\DisabilityType|null $disabilityType
 * @property-read \App\Models\Base\EmployeePayroll $employeePayroll
 * @property-read \App\Models\Catalogs\OtherPaymentType|null $otherPaymentType
 * @property-read \App\Models\Catalogs\OvertimesType|null $overtimesType1
 * @property-read \App\Models\Catalogs\OvertimesType|null $overtimesType2
 * @property-read \App\Models\Catalogs\OvertimesType|null $overtimesType3
 * @property-read \App\Models\Catalogs\Perception|null $perception
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereAcMarketValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereAcPriceWhenGranted($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereAmountCaused($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereAmountExempt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereAmountTaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereCmPositiveBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereCmRemainder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereCmYear($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereDeductionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereDisabilityAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereDisabilityDays($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereDisabilityTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereEmployeePayrollId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrAmountPaid1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrAmountPaid2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrAmountPaid3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrDays1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrDays2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrDays3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrHours1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrHours2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrHours3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrOvertimesTypeId1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrOvertimesTypeId2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereHrOvertimesTypeId3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereOtherPaymentTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine wherePerceptionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollLine whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class EmployeePayrollLine extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'employee_payroll_lines';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'employee_payroll_id',
        'name',
        'code',
        'perception_id',
        'deduction_id',
        'other_payment_type_id',
        'amount_taxed',
        'amount_exempt',
        'amount_total',
        'amount_caused',
        'sort_order',
        'status',
        'ac_market_value',
        'ac_price_when_granted',
        'hr_days_1',
        'hr_overtimes_type_id_1',
        'hr_hours_1',
        'hr_amount_paid_1',
        'hr_days_2',
        'hr_overtimes_type_id_2',
        'hr_hours_2',
        'hr_amount_paid_2',
        'hr_days_3',
        'hr_overtimes_type_id_3',
        'hr_hours_3',
        'hr_amount_paid_3',
        'cm_positive_balance',
        'cm_year',
        'cm_remainder',
        'disability_type_id',
        'disability_days',
        'disability_amount'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function employeePayroll()
    {
        return $this->belongsTo(EmployeePayroll::class);
    }

    public function perception()
    {
        return $this->belongsTo(Perception::class);
    }

    public function deduction()
    {
        return $this->belongsTo(Deduction::class);
    }

    public function otherPaymentType()
    {
        return $this->belongsTo(OtherPaymentType::class);
    }

    public function overtimesType1()
    {
        return $this->belongsTo(OvertimesType::class,'hr_overtimes_type_id_1','id');
    }

    public function overtimesType2()
    {
        return $this->belongsTo(OvertimesType::class,'hr_overtimes_type_id_2','id');
    }

    public function overtimesType3()
    {
        return $this->belongsTo(OvertimesType::class,'hr_overtimes_type_id_3','id');
    }

    public function disabilityType()
    {
        return $this->belongsTo(DisabilityType::class);
    }

}
