<?php

namespace App\Models\Base;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Base\EmployeePayrollOutsourcing
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $employee_payroll_id
 * @property string|null $taxid
 * @property float $percent_time
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Base\EmployeePayroll $employeePayroll
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereEmployeePayrollId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing wherePercentTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollOutsourcing whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class EmployeePayrollOutsourcing extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'employee_payroll_outsourcings';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'employee_payroll_id',
        'taxid',
        'percent_time',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['taxid','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function employeePayroll()
    {
        return $this->belongsTo(EmployeePayroll::class);
    }
}
