<?php

namespace App\Models\Base;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\EmployeePayrollRelation
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $employee_payroll_id
 * @property int|null $relation_id
 * @property int $sort_order
 * @property bool $status
 * @property string|null $uuid_related
 * @property-read \App\Models\Base\EmployeePayroll $employeePayroll
 * @property-read \App\Models\Base\EmployeePayroll|null $relation
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereEmployeePayrollId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereRelationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\EmployeePayrollRelation whereUuidRelated($value)
 * @mixin \Eloquent
 */
class EmployeePayrollRelation extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'employee_payroll_relations';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'employee_payroll_id',
        'relation_id',
        'sort_order',
        'status',
        'uuid_related'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function employeePayroll()
    {
        return $this->belongsTo(EmployeePayroll::class);
    }

    public function relation()
    {
        return $this->belongsTo(EmployeePayroll::class,'relation_id','id');
    }
}
