<?php

namespace App\Models\Base;

use App\Models\Auth\User;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\PaymentWay;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\Folio
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $taxid
 * @property string|null $product
 * @property string|null $product_code
 * @property float $quantity
 * @property float $price_unit
 * @property float $discount
 * @property float $price_reduce
 * @property int|null $payment_way_id
 * @property int|null $currency_id
 * @property float $currency_value
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property string|null $expiry_date
 * @property string|null $activation_date
 * @property string|null $activation_code
 * @property int $quantity_folio
 * @property int $available_folio
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Auth\User|null $createdUser
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereActivationCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereActivationDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereAvailableFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereExpiryDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio wherePriceReduce($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio wherePriceUnit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereProduct($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereProductCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereQuantity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereQuantityFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property string|null $payment_platform
 * @property string|null $payment_platform_request
 * @property string|null $payment_platform_response
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio wherePaymentPlatform($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio wherePaymentPlatformRequest($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Folio wherePaymentPlatformResponse($value)
 * @property-read mixed $payment_platform_name
 */
class Folio extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'folios';

    const PER_ACTIVE = 1; //Por activar
    const ACTIVE = 2; //Activos
    const FINISHED = 3; //Terminados
    const CANCELED = 4; //Cancelado

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'taxid',
        'product',
        'product_code',
        'quantity',
        'price_unit',
        'discount',
        'price_reduce',
        'payment_way_id',
        'currency_id',
        'currency_value',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'expiry_date',
        'activation_date',
        'activation_code',
        'quantity_folio',
        'available_folio',
        'sort_order',
        'status',
        'payment_platform',
        'payment_platform_request',
        'payment_platform_response'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['created_at','name','taxid','product','product_code','expiry_date','quantity_folio','available_folio', 'amount_total', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('product', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('product_code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('payment_platform', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=',self::ACTIVE);

        return $query;
    }

    public function scopePerActive($query)
    {
        $query->where('status','=',self::PER_ACTIVE);

        return $query;
    }

    public function getPaymentPlatformNameAttribute(){
        $payment_platform = collect(config('app.payment_platforms'))->where('code','=',$this->payment_platform)->first();
        return $payment_platform['name'] ?? $this->payment_platform;
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function createdUser()
    {
        return $this->belongsTo(User::class,'created_uid');
    }

}
