<?php

namespace App\Models\Base;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\Pac
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property string|null $ws_url
 * @property string|null $ws_url_cancel
 * @property string|null $username
 * @property string|null $password
 * @property bool $test
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property string|null $team_id
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereTeamId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereTest($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereUsername($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereWsUrl($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereWsUrlCancel($value)
 * @mixin \Eloquent
 * @property string|null $token
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Pac whereToken($value)
 */
class Pac extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'pacs';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'ws_url',
        'ws_url_cancel',
        'username',
        'password',
        'test',
        'comment',
        'sort_order',
        'status',
        'team_id',
        'token'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'ws_url', 'username', 'test', 'sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('ws_url', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('username', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

}
