<?php

namespace App\Models\Base;

use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Base\Setting
 *
 * @property int $id
 * @property string $key
 * @property string $value
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Setting newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Setting newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Setting query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Setting whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Setting whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Base\Setting whereValue($value)
 * @mixin \Eloquent
 */
class Setting extends Model
{
    use UsesTenantConnection;

    protected $table = 'settings';

    public $timestamps = false;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
    ];
}
