<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\Bank
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property string|null $taxid
 * @property int $sort_order
 * @property bool $status
 * @property string|null $description
 * @property-read mixed $name_sat
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Bank whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Bank extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'banks';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'taxid',
        'description',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code','description','taxid', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('description', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getNameSatAttribute(){
        return '[' . $this->code . '] ' . $this->name;
    }
}
