<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\City
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int|null $state_id
 * @property int $sort_order
 * @property bool $status
 * @property string|null $code
 * @property-read \App\Models\Catalogs\State|null $state
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereStateId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\City whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class City extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'cities';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'state_id', 'sort_order', 'status', 'code'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','state_id', 'sort_order', 'status', 'code'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhereHas('state', function ($q) use ($search) {
                $q->where('states.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $q->orWhereHas('country', function ($q2) use ($search) {
                    $q2->where('countries.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
            });
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }
}
