<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\Currency
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string $code
 * @property float $rate
 * @property int $decimal_place
 * @property string|null $symbol
 * @property string $symbol_position
 * @property string $decimal_mark
 * @property string $thousands_separator
 * @property int $sort_order
 * @property bool $status
 * @property-read mixed $name_sat
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereDecimalMark($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereDecimalPlace($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereRate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereSymbol($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereSymbolPosition($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereThousandsSeparator($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Currency whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Currency extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'currencies';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'code', 'rate', 'decimal_place', 'symbol', 'symbol_position', 'decimal_mark', 'thousands_separator', 'sort_order', 'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'rate', 'decimal_place', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getNameSatAttribute(){
        return '[' . $this->code . '] ' . $this->name;
    }
}
