<?php

namespace App\Models\Catalogs;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Catalogs\ExpenseType
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int $sort_order
 * @property int $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereUpdatedUid($value)
 * @mixin \Eloquent
 * @property int|null $type
 * @property-read mixed $type_name
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\ExpenseType whereType($value)
 */
class ExpenseType extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'expense_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'type', 'sort_order', 'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'type', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getTypeNameAttribute()
    {
        return $this->type == 1 ? __('base/cfdi_download.tab_received_2') : ($this->type == 2 ? __('base/cfdi_download.tab_issued_2') : '');
    }
}
