<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\IeduNivelEducativo
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property string|null $aut_rvoe
 * @property int $sort_order
 * @property bool $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereAutRvoe($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\IeduNivelEducativo whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class IeduNivelEducativo extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'iedu_nivel_educativos';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'code','aut_rvoe', 'sort_order', 'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code','aut_rvoe', 'sort_order', 'status'];

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('aut_rvoe', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }
}
