<?php

namespace App\Models\Catalogs;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Catalogs\OperationalType
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int $sort_order
 * @property bool $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OperationalType whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class OperationalType extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'operational_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'sort_order', 'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'type', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }
}
