<?php

namespace App\Models\Catalogs;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Catalogs\OtherPaymentType
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string $code
 * @property int $sort_order
 * @property bool $status
 * @property string|null $code2
 * @property-read mixed $description_select2
 * @property-read mixed $name_sat
 * @property-read mixed $text_select2
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereCode2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\OtherPaymentType whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class OtherPaymentType extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'other_payment_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'sort_order',
        'status',
        'code2',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'sort_order', 'status','code2'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('code', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        if (!empty($input['filter_search_select2'])) {
            $search = $input['filter_search_select2'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return '[' .$this->code . '] ' . $this->name;
    }

    public function getNameSatAttribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }
}
