<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\PaymentTerm
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int $days
 * @property int $sort_order
 * @property bool $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereDays($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\PaymentTerm whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class PaymentTerm extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'payment_terms';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'days', 'sort_order', 'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'days', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('days', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }
}
