<?php

namespace App\Models\Catalogs;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Catalogs\Postcode
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code_state
 * @property string|null $code_city
 * @property string|null $code_location
 * @property int $diff1
 * @property int $diff2
 * @property int $sort_order
 * @property bool $status
 * @property-read mixed $name_sat
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereCodeCity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereCodeLocation($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereCodeState($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereDiff1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereDiff2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Postcode whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Postcode extends Model
{
    Use Sortable, UsesTenantConnection;

    protected $table = 'postcodes';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code_state',
        'code_city',
        'code_location',
        'diff1',
        'diff2',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code_state', 'code_city', 'code_location', 'diff1', 'diff2', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code_state', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code_city', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code_location', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getNameSatAttribute()
    {
        return $this->name;
    }

}
