<?php

namespace App\Models\Catalogs;

use App\Models\Base\Company;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\Product
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property string|null $description
 * @property string|null $image
 * @property string|null $model
 * @property string|null $manufacturer
 * @property float $price
 * @property int|null $unit_measure_id
 * @property int|null $sat_product_id
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property int|null $company_id
 * @property int|null $tariff_fraction_id
 * @property int|null $uom_custom_id
 * @property-read \App\Models\Base\Company|null $company
 * @property-read mixed $description_select2
 * @property-read mixed $text_select2
 * @property-read \App\Models\Catalogs\SatProduct|null $satProduct
 * @property-read \App\Models\Catalogs\TariffFraction|null $tariffFraction
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Catalogs\Tax[] $taxes
 * @property-read \App\Models\Catalogs\UnitMeasure|null $unitMeasure
 * @property-read \App\Models\Catalogs\UomCustom|null $uomCustom
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereManufacturer($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereModel($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereSatProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereTariffFractionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereUnitMeasureId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereUomCustomId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Product whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Product extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'products';

    const PATH_IMAGES = 'images/products';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'description',
        'image',
        'model',
        'manufacturer',
        'price',
        'unit_measure_id',
        'sat_product_id',
        'comment',
        'sort_order',
        'status',
        'company_id',
        'tariff_fraction_id',
        'uom_custom_id',
        'price_decimal_place',
        'quota_ieps',
        'tax_object'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','code','model','manufacturer','price', 'sort_order', 'status'];

    /**
     * @return string
     */
    public function pathImage(){
        if(!empty(setting('products_per_taxid'))){
            return '/app-images-company/'.$this->company_id.'/' . self::PATH_IMAGES . '/' . $this->image;
        }

        return '/app-images/' . self::PATH_IMAGES . '/' . $this->image;
    }

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            if(!empty(setting('products_per_taxid'))){
                $query->where('products.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
            }else{
                $query->where('products.company_id', '=', \App\Helpers\Helper::firstCompany()->id);
            }
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('description', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('model', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('manufacturer', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhereHas('unitMeasure', function ($q) use ($search) {
                    $q->where('unit_measures.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('satProduct', function ($q) use ($search) {
                    $q->where('sat_products.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
            }

            if (!empty($input['filter_search_select2'])) {
                $search = $input['filter_search_select2'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('description', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
        });

        return $query;
    }

    public function scopeActive($query)
    {
        if(!empty(setting('products_per_taxid'))){
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        }else{
            $query->where('company_id', '=', \App\Helpers\Helper::firstCompany()->id);
        }
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        if(!empty(setting('products_per_taxid'))){
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        }else{
            $query->where('company_id', '=', \App\Helpers\Helper::firstCompany()->id);
        }
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return (!empty($this->code) ? $this->code : '0000');
    }

    public function getDescriptionSelect2Attribute()
    {
        return '[' . (!empty($this->code) ? $this->code : '0000') . '] ' . $this->name;
    }

    public function unitMeasure()
    {
        return $this->belongsTo(UnitMeasure::class);
    }

    public function satProduct()
    {
        return $this->belongsTo(SatProduct::class);
    }

    public function taxes()
    {
        return $this->belongsToMany(Tax::class,'product_taxes');
    }
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function tariffFraction()
    {
        return $this->belongsTo(TariffFraction::class);
    }

    public function uomCustom()
    {
        return $this->belongsTo(UomCustom::class);
    }

}
