<?php

namespace App\Models\Catalogs;

use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

/**
 * App\Models\Catalogs\Project
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string|null $name
 * @property string|null $description
 * @property string|null $logo_docs
 * @property int $sort_order
 * @property bool $status
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereLogoDocs($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\Project whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Project extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'projects';
    const PATH_LOGO_DOCS = 'images/projects';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'description', 'logo_docs', 'sort_order', 'status', 'company_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','description', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * @return string
     */
    public function pathLogoDocs(){
        if(!empty(setting('projects_per_taxid'))){
            return '/app-images-company/'.$this->company_id.'/' . self::PATH_LOGO_DOCS . '/' . $this->logo_docs;
        }

        return '/app-images/' . self::PATH_LOGO_DOCS . '/' . $this->logo_docs;
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            if(!empty(setting('projects_per_taxid'))){
                $query->where('projects.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
            }else{
                $query->where('projects.company_id', '=', \App\Helpers\Helper::firstCompany()->id);
            }
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('description', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
        });

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        if(!empty(setting('projects_per_taxid'))){
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        }else{
            $query->where('company_id', '=', \App\Helpers\Helper::firstCompany()->id);
        }
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }
}
