<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

class ReasonCancellation extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'reason_cancellations';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('code');
        $query->orderBy('name');

        return $query;
    }

    public function getNameSatAttribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }
}
