<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\State
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property int|null $country_id
 * @property int $sort_order
 * @property bool $status
 * @property string|null $code
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Catalogs\City[] $cities
 * @property-read \App\Models\Catalogs\Country|null $country
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereCountryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\State whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class State extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'states';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'country_id', 'sort_order', 'status','code',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'sort_order', 'status','code'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhereHas('country', function ($q) use ($search) {
                $q->where('countries.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            });
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function cities()
    {
        return $this->hasMany(City::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
