<?php

namespace App\Models\Catalogs;

use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

class Station extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'stations';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid', 'updated_uid', 'name', 'code', 'sort_order', 'status','transport_type_id','nationality','designator','railway_line',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'sort_order', 'status','transport_type_id','nationality','designator','railway_line'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('nationality', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        if (!empty($input['filter_search_select2'])) {
            $search = $input['filter_search_select2'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('nationality', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }

    public function getNameSatAttribute(){
        return '[' . $this->code . '] ' . $this->name;
    }

    public function transportType()
    {
        return $this->belongsTo(TransportType::class);
    }
}
