<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\TransferReason
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $code
 * @property int $sort_order
 * @property bool $status
 * @property-read mixed $description_select2
 * @property-read mixed $name_sat
 * @property-read mixed $text_select2
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\TransferReason whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class TransferReason extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'transfer_reasons';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        if (!empty($input['filter_search_select2'])) {
            $search = $input['filter_search_select2'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('code');
        $query->orderBy('name');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }

    public function getNameSatAttribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }
}
