<?php

namespace App\Models\Catalogs;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Catalogs\UnitMeasure
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string $code
 * @property int $decimal_place
 * @property int $sort_order
 * @property bool $status
 * @property-read mixed $description_select2
 * @property-read mixed $name_sat
 * @property-read mixed $text_select2
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereDecimalPlace($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Catalogs\UnitMeasure whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class UnitMeasure extends Model
{
    Use Sortable,UsesTenantConnection;

    protected $table = 'unit_measures';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'code',
        'decimal_place',
        'sort_order',
        'status',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name', 'code', 'decimal_place', 'sort_order', 'status'];
    public function generalSortable($query, $direction)
    {
        return $query->orderBy('sort_order', $direction)->orderBy('name', $direction);
    }

    /**
     * Funcion para busqueda general
     *
     * @param $query
     * @param array $input
     * @return mixed
     */
    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        if (!empty($input['filter_code'])) {
            $code = $input['filter_code'];
            $query->where('code', '=', $code);
        }

        if (!empty($input['filter_search_select2'])) {
            $search = $input['filter_search_select2'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('code', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status', '=', '1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }

    public function getNameSatAttribute()
    {
        return '[' . $this->code . '] ' . $this->name;
    }
}
