<?php

namespace App\Models\Sales;

use App\Models\Base\BlackListSat;
use App\Models\Base\Company;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\State;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use App\Models\Catalogs\TaxRegimen;

/**
 * App\Models\Sales\Customer
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $taxid
 * @property string|null $numid
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $phone_mobile
 * @property int|null $payment_term_id
 * @property int|null $payment_way_id
 * @property int|null $payment_method_id
 * @property int|null $cfdi_use_id
 * @property int|null $salesperson_id
 * @property string|null $address_1
 * @property string|null $address_2
 * @property string|null $address_3
 * @property string|null $address_4
 * @property string|null $address_5
 * @property string|null $address_6
 * @property int|null $city_id
 * @property int|null $state_id
 * @property int $country_id
 * @property string|null $postcode
 * @property string|null $comment
 * @property int $sort_order
 * @property bool $status
 * @property int|null $company_id
 * @property-read \App\Models\Catalogs\CfdiUse|null $cfdiUse
 * @property-read \App\Models\Catalogs\City|null $city
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Country $country
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerBankAccount[] $customerActiveBankAccounts
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerIedu[] $customerActiveIedus
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerBankAccount[] $customerBankAccounts
 * @property-read mixed $description_select2
 * @property-read mixed $text_select2
 * @property-read \App\Models\Catalogs\PaymentMethod|null $paymentMethod
 * @property-read \App\Models\Catalogs\PaymentTerm|null $paymentTerm
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @property-read \App\Models\Sales\Salesperson|null $salesperson
 * @property-read \App\Models\Catalogs\State|null $state
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereAddress1($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereAddress2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereAddress3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereAddress4($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereAddress5($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereAddress6($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereCfdiUseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereCityId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereCountryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereNumid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer wherePaymentMethodId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer wherePaymentTermId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer wherePhoneMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer wherePostcode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereSalespersonId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereStateId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\Customer whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class Customer extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'taxid',
        'numid',
        'email',
        'phone',
        'phone_mobile',
        'payment_term_id',
        'payment_way_id',
        'payment_method_id',
        'cfdi_use_id',
        'salesperson_id',
        'address_1',
        'address_2',
        'address_3',
        'address_4',
        'address_5',
        'address_6',
        'city_id',
        'state_id',
        'country_id',
        'postcode',
        'comment',
        'sort_order',
        'status',
        'company_id',
        'tax_regimen_id',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','taxid','email','phone', 'sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            if(!empty(setting('customers_per_taxid'))){
                $query->where('customers.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
            }else{
                $query->where('customers.company_id', '=', \App\Helpers\Helper::firstCompany()->id);
            }
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                /*$query->orWhere('email', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('phone', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhereHas('paymentTerm', function ($q) use ($search) {
                    $q->where('payment_terms.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('paymentWay', function ($q) use ($search) {
                    $q->where('payment_ways.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('paymentMethod', function ($q) use ($search) {
                    $q->where('payment_methods.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('cfdiUse', function ($q) use ($search) {
                    $q->where('cfdi_uses.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('salesperson', function ($q) use ($search) {
                    $q->where('salespersons.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });
                $query->orWhereHas('country', function ($q) use ($search) {
                    $q->where('countries.name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                });*/
            }

            if (!empty($input['filter_search_select2'])) {
                $search = $input['filter_search_select2'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
                $query->orWhere('taxid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
        });

        return $query;
    }

    /**
     * Solo registros activos
     *
     * @param $query
     * @return mixed
     */
    public function scopeActive($query)
    {
        if(!empty(setting('customers_per_taxid'))){
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        }else{
            $query->where('company_id', '=', \App\Helpers\Helper::firstCompany()->id);
        }
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        if(!empty(setting('customers_per_taxid'))){
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        }else{
            $query->where('company_id', '=', \App\Helpers\Helper::firstCompany()->id);
        }
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return $this->name;
    }

    public function paymentTerm()
    {
        return $this->belongsTo(PaymentTerm::class);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function cfdiUse()
    {
        return $this->belongsTo(CfdiUse::class);
    }

    public function salesperson()
    {
        return $this->belongsTo(Salesperson::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function customerBankAccounts()
    {
        return $this->hasMany(CustomerBankAccount::class);
    }

    public function customerActiveBankAccounts()
    {
        return $this->hasMany(CustomerBankAccount::class)->where('status','=','1');
    }

    public function customerActiveIedus()
    {
        return $this->hasMany(CustomerIedu::class)->where('status','=','1');
    }
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function blackListSat()
    {
        return $this->belongsTo(BlackListSat::class,'taxid','taxid');
    }
    public function taxRegimen()
    {
        return $this->belongsTo(TaxRegimen::class);
    }
}
