<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Bank;
use App\Models\Catalogs\Currency;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerBankAccount
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_id
 * @property string $name
 * @property string $account_number
 * @property int $bank_id
 * @property int $currency_id
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Catalogs\Bank $bank
 * @property-read \App\Models\Catalogs\Currency $currency
 * @property-read \App\Models\Sales\Customer $customer
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereAccountNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereBankId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerBankAccount whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerBankAccount extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_bank_accounts';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_id',
        'name',
        'account_number',
        'bank_id',
        'currency_id',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','account_number','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('account_number', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
}
