<?php

namespace App\Models\Sales;

use App\Models\Catalogs\IeduNivelEducativo;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerIedu
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $customer_id
 * @property string|null $name
 * @property string|null $nombre_alumno
 * @property string|null $curp
 * @property int|null $iedu_nivel_educativo_id
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\Customer|null $customer
 * @property-read \App\Models\Catalogs\IeduNivelEducativo|null $ieduNivelEducativo
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu populateSelect()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereCurp($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereIeduNivelEducativoId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereNombreAlumno($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerIedu whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerIedu extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_iedus';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_id',
        'name',
        'nombre_alumno',
        'curp',
        'iedu_nivel_educativo_id',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','nombre_alumno','curp','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('nombre_alumno', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('curp', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    /**
     * Funcion para llenado de datos en un select
     *
     * @param $query
     * @return mixed
     */
    public function scopePopulateSelect($query)
    {
        $query->where('status','=','1');
        $query->orderBy('sort_order');
        $query->orderBy('name');

        return $query;
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function ieduNivelEducativo()
    {
        return $this->belongsTo(IeduNivelEducativo::class);
    }
}
