<?php

namespace App\Models\Sales;

use App\Helpers\Helper;
use App\Models\Base\Company;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Project;
use App\Models\Base\BranchOffice;
use App\Models\Base\DocumentType;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\Incoterm;
use App\Models\Catalogs\Pediment;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\TaxRegimen;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Catalogs\OperationType;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\TransferReason;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerInvoice
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property string $name
 * @property string|null $serie
 * @property int|null $folio
 * @property string|null $date
 * @property string|null $date_due
 * @property string|null $reference
 * @property int|null $customer_id
 * @property int|null $branch_office_id
 * @property int|null $payment_term_id
 * @property int|null $payment_way_id
 * @property int|null $payment_method_id
 * @property int|null $cfdi_use_id
 * @property int|null $salesperson_id
 * @property int|null $currency_id
 * @property float $currency_value
 * @property float $amount_discount
 * @property float $amount_untaxed
 * @property float $amount_tax
 * @property float $amount_tax_ret
 * @property float $amount_total
 * @property float $balance
 * @property int|null $document_type_id
 * @property int|null $cfdi_relation_id
 * @property string|null $comment
 * @property bool $mail_sent
 * @property int $sort_order
 * @property bool $status
 * @property string|null $confirmacion
 * @property string|null $date_delivery
 * @property string|null $source
 * @property string|null $source_name
 * @property string|null $source_taxid
 * @property string|null $source_address
 * @property string|null $source_delivery_on
 * @property string|null $destination
 * @property string|null $destination_name
 * @property string|null $destination_taxid
 * @property string|null $destination_address
 * @property string|null $destination_delivery_on
 * @property float $valid_amount
 * @property bool $dangerous_material
 * @property string|null $compensation
 * @property string|null $retainer_name
 * @property string|null $retainer_taxid
 * @property string|null $driver
 * @property string|null $vehicle
 * @property string|null $vehicle_number
 * @property string|null $vehicle_counter
 * @property string|null $cfdi_type2
 * @property string|null $document_type2
 * @property int|null $company_id
 * @property string|null $draft
 * @property int|null $transfer_reason_id
 * @property int|null $operation_type_id
 * @property int|null $pediment_id
 * @property string|null $origin_certificate
 * @property string|null $number_origin_certificate
 * @property string|null $reliable_exporter_number
 * @property int|null $incoterm_id
 * @property string|null $subdivision
 * @property string|null $comment_foreign_trade
 * @property float $exchange_rate_usd
 * @property float $amount_total_usd
 * @property string|null $origin
 * @property int|null $customer_quotation_id
 * @property-read \App\Models\Base\BranchOffice|null $branchOffice
 * @property-read \App\Models\Catalogs\CfdiRelation|null $cfdiRelation
 * @property-read \App\Models\Catalogs\CfdiUse|null $cfdiUse
 * @property-read \App\Models\Base\Company|null $company
 * @property-read \App\Models\Catalogs\Currency|null $currency
 * @property-read \App\Models\Sales\Customer|null $customer
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerInvoiceLineTransfer[] $customerActiveInvoiceLineTransfers
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerInvoiceLine[] $customerActiveInvoiceLines
 * @property-read \App\Models\Sales\CustomerInvoiceCfdi $customerInvoiceCfdi
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerInvoiceLine[] $customerInvoiceLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerInvoiceReconciled[] $customerInvoiceReconcileds
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerInvoiceRelation[] $customerInvoiceRelations
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerInvoiceTax[] $customerInvoiceTaxes
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Sales\CustomerPaymentReconciled[] $customerPaymentHistory
 * @property-read \App\Models\Base\DocumentType|null $documentType
 * @property-read mixed $description_select2
 * @property-read mixed $text_select2
 * @property-read \App\Models\Catalogs\Incoterm|null $incoterm
 * @property-read \App\Models\Catalogs\OperationType|null $operationType
 * @property-read \App\Models\Catalogs\PaymentMethod|null $paymentMethod
 * @property-read \App\Models\Catalogs\PaymentTerm|null $paymentTerm
 * @property-read \App\Models\Catalogs\PaymentWay|null $paymentWay
 * @property-read \App\Models\Catalogs\Pediment|null $pediment
 * @property-read \App\Models\Sales\Salesperson|null $salesperson
 * @property-read \App\Models\Catalogs\TransferReason|null $transferReason
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice totalDashboard($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereAmountDiscount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereAmountTax($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereAmountTaxRet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereAmountTotal($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereAmountTotalUsd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereAmountUntaxed($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereBranchOfficeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCfdiRelationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCfdiType2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCfdiUseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereComment($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCommentForeignTrade($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCompensation($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereConfirmacion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCurrencyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCurrencyValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereCustomerQuotationId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDangerousMaterial($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDateDelivery($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDateDue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDestination($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDestinationAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDestinationDeliveryOn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDestinationName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDestinationTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDocumentType2($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDocumentTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDraft($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereDriver($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereExchangeRateUsd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereFolio($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereIncotermId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereMailSent($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereNumberOriginCertificate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereOperationTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereOrigin($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereOriginCertificate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice wherePaymentMethodId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice wherePaymentTermId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice wherePaymentWayId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice wherePedimentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereReliableExporterNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereRetainerName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereRetainerTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSalespersonId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSerie($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSource($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSourceAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSourceDeliveryOn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSourceName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSourceTaxid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereSubdivision($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereTransferReasonId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereValidAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereVehicle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereVehicleCounter($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereVehicleNumber($value)
 * @mixin \Eloquent
 * @property int|null $project_id
 * @property-read \App\Models\Catalogs\Project|null $project
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereProjectId($value)
 * @property string|null $title
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoice whereTitle($value)
 */
class CustomerInvoice extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoices';

    const PATH_XML_FILES_CI = 'files/customer_invoices/xml';
    const PATH_XML_FILES_CCN = 'files/customer_credit_notes/xml';
    const PATH_XML_FILES_CTR = 'files/customer_transfers/xml';
    const PATH_XML_FILES_LEA = 'files/customer_leases/xml';
    const PATH_XML_FILES_FEE = 'files/customer_fees/xml';

    //Por timbrar
    const DRAFT = 1;
    const OPEN = 2; //Abierta
    const PAID = 3; //Pagada
    const CANCEL = 4; //Cancelada
    const RECONCILED = 5; //Aplicada
    const CANCEL_PER_AUTHORIZED = 6; //Cancelacion por autorizar en el SAT
    const TO_PAY = 7; //Por cobrar
    const PER_RECONCILED = 8; //Por aplicar

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'name',
        'serie',
        'folio',
        'date',
        'date_due',
        'reference',
        'customer_id',
        'branch_office_id',
        'payment_term_id',
        'payment_way_id',
        'payment_method_id',
        'cfdi_use_id',
        'salesperson_id',
        'currency_id',
        'currency_value',
        'amount_discount',
        'amount_untaxed',
        'amount_tax',
        'amount_tax_ret',
        'amount_total',
        'balance',
        'document_type_id',
        'cfdi_relation_id',
        'comment',
        'mail_sent',
        'sort_order',
        'status',
        'confirmacion',
        'date_delivery',
        'source',
        'source_name',
        'source_taxid',
        'source_address',
        'source_delivery_on',
        'destination',
        'destination_name',
        'destination_taxid',
        'destination_address',
        'destination_delivery_on',
        'valid_amount',
        'dangerous_material',
        'compensation',
        'retainer_name',
        'retainer_taxid',
        'driver',
        'vehicle',
        'vehicle_number',
        'vehicle_counter',
        'cfdi_type2',
        'document_type2',
        'company_id',
        'draft',
        'transfer_reason_id',
        'operation_type_id',
        'pediment_id',
        'origin_certificate',
        'number_origin_certificate',
        'reliable_exporter_number',
        'incoterm_id',
        'subdivision',
        'comment_foreign_trade',
        'exchange_rate_usd',
        'amount_total_usd',
        'origin',
        'customer_quotation_id',
        'title',
        'project_id',
        'tax_regimen_id',
        'tax_regimen_customer_id',
        'customer_remission_id',
        'global_periodicity',
        'global_month',
        'global_year',
        'addenda'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
        'name',
        'date',
        'date_due',
        'amount_untaxed',
        'amount_total',
        'balance',
        'mail_sent',
        'sort_order',
        'status',
        'origin'
    ];

    public function scopeFilter($query, array $input = [])
    {
        $query->where(function ($query) {
            $query->where('customer_invoices.company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            if (!empty($input['filter_search'])) {
                $search = $input['filter_search'];
                $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            }
            if (!empty($input['filter_document_type_code'])) {
                $filter_document_type_code = $input['filter_document_type_code'];
                $query->WhereHas('documentType', function ($q) use ($filter_document_type_code) {
                    if(is_array($filter_document_type_code)){
                        $q->whereIn('document_types.code', $filter_document_type_code);
                    }else {
                        $q->where('document_types.code', '=', $filter_document_type_code);
                    }
                });
            }
            if (!empty($input['filter_cfdi_type2'])) {
                $cfdi_type2 = $input['filter_cfdi_type2'];
                $query->where('cfdi_type2', '=', $cfdi_type2);
            }
            if (!empty($input['filter_name'])) {
                $name = $input['filter_name'];
                $query->where('name', 'like', '%' . str_replace(' ', '%%', $name) . '%');
            }
            if (!empty($input['filter_folio_range'])) {
                if(str_contains($input['filter_folio_range'],',')){
                    $range = explode(',',$input['filter_folio_range']);
                    if(!empty($range)){
                        foreach ($range as $key => $tmp){
                            $range[$key] = (int) $tmp;
                            $query->whereIn('folio', $range);
                        }
                    }
                }elseif(str_contains($input['filter_folio_range'],'-')){
                    $range = explode('-',$input['filter_folio_range']);
                    if(!empty($range)){
                        foreach ($range as $key => $tmp){
                            $range[$key] = (int) $tmp;
                            $query->whereBetween('folio', $range);
                        }
                    }
                }elseif(is_int($input['filter_folio_range'])){
                    $query->whereIn('folio', [$input['filter_folio_range']]);
                }
            }
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('date', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('date', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_payment_way_id'])) {
                $payment_way_id = $input['filter_payment_way_id'];
                $query->where('payment_way_id', '=', $payment_way_id);
            }
            if (!empty($input['filter_customer_id'])) {
                $customer_id = $input['filter_customer_id'];
                $query->where('customer_id', '=', $customer_id);
            }
            if (!empty($input['filter_currency_id'])) {
                $currency_id = $input['filter_currency_id'];
                $query->where('currency_id', '=', $currency_id);
            }
            if (!empty($input['filter_branch_office_id'])) {
                $branch_office_id = $input['filter_branch_office_id'];
                $query->where('branch_office_id', '=', $branch_office_id);
            }
            if (!empty($input['filter_salesperson_id'])) {
                $salesperson_id = $input['filter_salesperson_id'];
                $query->where('salesperson_id', '=', $salesperson_id);
            }
            if (!empty($input['filter_project_id'])) {
                $project_id = $input['filter_project_id'];
                $query->where('project_id', '=', $project_id);
            }
            if (!empty($input['filter_status'])) {
                $status = $input['filter_status'];
                $query->where('customer_invoices.status', '=', $status);
            }
            if (!empty($input['filter_search_cfdi_select2'])) {
                $search = $input['filter_search_cfdi_select2'];
                //agregar los estatus y que tengan UUID para buscar
                $query->whereIn('status', [self::OPEN, self::PAID, self::RECONCILED, self::CANCEL, self::CANCEL_PER_AUTHORIZED,self::TO_PAY,self::PER_RECONCILED])
                    ->whereHas('customerInvoiceCfdi', function ($q) {
                        $q->where('customer_invoice_cfdis.uuid', '<>', '');
                    })
                    ->where(function ($q) use ($search) {
                        $q->where('name', 'like', '%' . str_replace(' ', '%%', $search) . '%')
                            ->orWhereHas('customerInvoiceCfdi', function ($q) use ($search) {
                                $q->where('customer_invoice_cfdis.uuid', 'like',
                                    '%' . str_replace(' ', '%%', $search) . '%');
                            });
                    });
            }
            if (!empty($input['filter_balances'])) {
                $query->whereIn('customer_invoices.status', [self::OPEN,self::TO_PAY,self::PER_RECONCILED])
                    ->where('balance','>',0);
            }
        });

        return $query;
    }

    public function scopeTotalDashboard($query, array $input = []){
        $query->where(function ($query) {
            $query->where('company_id', '=', \App\Helpers\Helper::defaultCompany()->id);
        })->where(function($query) use ($input) {
            $query->whereIn('status', [self::OPEN,self::PAID,self::RECONCILED,self::CANCEL_PER_AUTHORIZED,self::TO_PAY,self::PER_RECONCILED]);
            if (!empty($input['filter_date_from'])) {
                $query->whereDate('date', '>=', Helper::convertDateToSql($input['filter_date_from']));
            }
            if (!empty($input['filter_date_to'])) {
                $query->whereDate('date', '<=', Helper::convertDateToSql($input['filter_date_to']));
            }
            if (!empty($input['filter_document_type_code'])) {
                $filter_document_type_code = $input['filter_document_type_code'];
                $query->WhereHas('documentType', function ($q) use ($filter_document_type_code) {
                    if(is_array($filter_document_type_code)){
                        $q->whereIn('document_types.code', $filter_document_type_code);
                    }else {
                        $q->where('document_types.code', '=', $filter_document_type_code);
                    }
                });
            }
        });

        return $query;
    }

    public function getGlobalPeriodicitySAttribute(){
        $_ = __('general.text_global_periodicities');
        return !empty($_[$this->global_periodicity]) ? $_[$this->global_periodicity] : '';
    }

    public function getGlobalMonthSAttribute(){
        $_ = __('general.text_months');
        return !empty($_[$this->global_month]) ? $_[$this->global_month] : '';
    }

    public function getTextSelect2Attribute()
    {
        return $this->name;
    }

    public function getDescriptionSelect2Attribute()
    {
        return $this->name;
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function branchOffice()
    {
        return $this->belongsTo(BranchOffice::class);
    }

    public function paymentTerm()
    {
        return $this->belongsTo(PaymentTerm::class);
    }

    public function paymentWay()
    {
        return $this->belongsTo(PaymentWay::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function cfdiUse()
    {
        return $this->belongsTo(CfdiUse::class);
    }

    public function salesperson()
    {
        return $this->belongsTo(Salesperson::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function documentType()
    {
        return $this->belongsTo(DocumentType::class);
    }

    public function cfdiRelation()
    {
        return $this->belongsTo(CfdiRelation::class);
    }

    public function customerInvoiceLines()
    {
        return $this->hasMany(CustomerInvoiceLine::class);
    }

    public function customerActiveInvoiceLines()
    {
        return $this->hasMany(CustomerInvoiceLine::class)->where('status','=','1');
    }

    public function customerActiveInvoiceLineTransfers()
    {
        return $this->hasMany(CustomerInvoiceLineTransfer::class)->where('status','=','1');
    }

    public function customerInvoiceTaxes()
    {
        return $this->hasMany(CustomerInvoiceTax::class);
    }

    public function customerInvoiceReconcileds()
    {
        return $this->hasMany(CustomerInvoiceReconciled::class);
    }

    public function customerActiveInvoiceReconcileds()
    {
        return $this->hasMany(CustomerInvoiceReconciled::class)->where('status','=','1');
    }

    public function customerInvoiceRelations()
    {
        return $this->hasMany(CustomerInvoiceRelation::class);
    }

    public function customerInvoiceCfdi()
    {
        return $this->hasOne(CustomerInvoiceCfdi::class);
    }

    public function customerPaymentHistory()
    {
        return $this->hasMany(CustomerPaymentReconciled::class,'reconciled_id')
            ->where('status','=','1')
            ->whereHas('customerPayment', function ($q) {
                $q->whereIn('customer_payments.status', [CustomerPayment::OPEN,CustomerPayment::RECONCILED,CustomerPayment::PER_RECONCILED]);
            });
    }

    public function customerCreditNoteHistory()
    {
        return $this->hasMany(CustomerInvoiceReconciled::class,'reconciled_id')
            ->where('status','=','1')
            ->whereHas('customerInvoice', function ($q) {
                $q->whereIn('customer_invoices.status', [self::OPEN,self::RECONCILED,self::PER_RECONCILED])
                ->whereHas('documentType', function ($q2) {
                    $q2->whereIn('document_types.code', ['customer.credit_note']);
                });
            });
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function transferReason()
    {
        return $this->belongsTo(TransferReason::class);
    }

    public function operationType()
    {
        return $this->belongsTo(OperationType::class);
    }

    public function pediment()
    {
        return $this->belongsTo(Pediment::class);
    }

    public function incoterm()
    {
        return $this->belongsTo(Incoterm::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function customerInvoiceTaxLegends()
    {
        return $this->hasMany(CustomerInvoiceTaxLegend::class);
    }

    public function customerActiveInvoiceTaxLegends()
    {
        return $this->hasMany(CustomerInvoiceTaxLegend::class)->where('status','=','1');
    }

    public function taxRegimen()
    {
        return $this->belongsTo(TaxRegimen::class);
    }

    public function customerInvoiceTransfer()
    {
        return $this->hasOne(CustomerInvoiceTransfer::class);
    }

    public function taxRegimenCustomer()
    {
        return $this->belongsTo(TaxRegimen::class, 'tax_regimen_customer_id');
    }

    public function customerInvoiceComplement()
    {
        return $this->hasOne(CustomerInvoiceComplement::class);
    }

    public function customerActiveInvoiceInes()
    {
        return $this->hasMany(CustomerInvoiceIne::class)->where('status','=','1');
    }

    public function customerQuotation()
    {
        return $this->belongsTo(CustomerQuotation::class);
    }

    public function customerRemission()
    {
        return $this->belongsTo(CustomerRemission::class);
    }
}
