<?php

namespace App\Models\Sales;

use App\Models\Base\Pac;
use App\Models\Catalogs\ReasonCancellation;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerInvoiceCfdi
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_invoice_id
 * @property string $name
 * @property int|null $pac_id
 * @property string|null $cfdi_version
 * @property string|null $uuid
 * @property string|null $date
 * @property string|null $file_xml
 * @property string|null $file_xml_pac
 * @property string|null $cancel_date
 * @property string|null $cancel_response
 * @property string|null $cancel_state
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerInvoice $customerInvoice
 * @property-read \App\Models\Base\Pac|null $pac
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCancelDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCancelResponse($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCancelState($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCfdiVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereCustomerInvoiceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereFileXml($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereFileXmlPac($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi wherePacId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceCfdi whereUuid($value)
 * @mixin \Eloquent
 */
class CustomerInvoiceCfdi extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_cfdis';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_id',
        'name',
        'pac_id',
        'cfdi_version',
        'uuid',
        'date',
        'file_xml',
        'file_xml_pac',
        'cancel_date',
        'cancel_response',
        'cancel_state',
        'status',
        'reason_cancellation_id',
        'reason_cancellation_uuid'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
            $query->orWhere('uuid', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerInvoice()
    {
        return $this->belongsTo(CustomerInvoice::class);
    }

    public function pac()
    {
        return $this->belongsTo(Pac::class);
    }

    public function reasonCancellation()
    {
        return $this->belongsTo(ReasonCancellation::class);
    }
}
