<?php

namespace App\Models\Sales;

use Kyslik\ColumnSortable\Sortable;
use App\Models\Sales\CustomerInvoice;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

class CustomerInvoiceComplement extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_complements';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_id',
        'ine_process_type',
        'ine_committee_type',
        'ine_id_accounting',
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = [
    ];

    public function customerInvoice()
    {
        return $this->belongsTo(CustomerInvoice::class);
    }
}
