<?php

namespace App\Models\Sales;

use Kyslik\ColumnSortable\Sortable;
use Illuminate\Database\Eloquent\Model;
use Hyn\Tenancy\Traits\UsesTenantConnection;

class CustomerInvoiceIne extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_ines';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_id',
        'ine_entity',
        'ambit',
        'id_accounting',
        'sort_order',
        'status'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['entity','sort_order', 'status'];

    public function getIneEntitySAttribute()
    {
        $_ = __('general.text_ine_entities');
        return !empty($_[$this->ine_entity]) ? $_[$this->ine_entity] : '';
    }

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('ine_entity', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerInvoice()
    {
        return $this->belongsTo(CustomerInvoice::class);
    }
}
