<?php

namespace App\Models\Sales;

use App\Models\Catalogs\TariffFraction;
use App\Models\Catalogs\UomCustom;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerInvoiceLineComplement
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int|null $customer_invoice_line_id
 * @property string|null $name
 * @property int|null $customer_iedu_id
 * @property string|null $iedu_nombre_alumno
 * @property string|null $iedu_curp
 * @property string|null $iedu_nivel_educativo
 * @property string|null $iedu_aut_rvoe
 * @property string|null $iedu_rfc_pago
 * @property int $sort_order
 * @property bool $status
 * @property string|null $numero_predial
 * @property int|null $tariff_fraction_id
 * @property float $customs_quantity
 * @property int|null $uom_custom_id
 * @property float $price_unit_usd
 * @property float $amount_usd
 * @property-read \App\Models\Sales\CustomerInvoiceLine|null $customerInvoiceLine
 * @property-read \App\Models\Catalogs\TariffFraction|null $tariffFraction
 * @property-read \App\Models\Catalogs\UomCustom|null $uomCustom
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereAmountUsd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereCustomerIeduId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereCustomerInvoiceLineId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereCustomsQuantity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereIeduAutRvoe($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereIeduCurp($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereIeduNivelEducativo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereIeduNombreAlumno($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereIeduRfcPago($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereNumeroPredial($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement wherePriceUnitUsd($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereTariffFractionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereUomCustomId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineComplement whereUpdatedUid($value)
 * @mixin \Eloquent
 */
class CustomerInvoiceLineComplement extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_line_complements';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_line_id',
        'name',
        'customer_iedu_id',
        'iedu_nombre_alumno',
        'iedu_curp',
        'iedu_nivel_educativo',
        'iedu_aut_rvoe',
        'iedu_rfc_pago',
        'sort_order',
        'status',
        'numero_predial',
        'tariff_fraction_id',
        'customs_quantity',
        'uom_custom_id',
        'price_unit_usd',
        'amount_usd',
        'numero_pedimento'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerInvoiceLine()
    {
        return $this->belongsTo(CustomerInvoiceLine::class);
    }

    public function tariffFraction()
    {
        return $this->belongsTo(TariffFraction::class);
    }

    public function uomCustom()
    {
        return $this->belongsTo(UomCustom::class);
    }

}
