<?php

namespace App\Models\Sales;

use App\Models\Catalogs\Product;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\SatProduct;
use Kyslik\ColumnSortable\Sortable;
use App\Models\Catalogs\UnitMeasure;
use App\Models\Catalogs\PackagingType;
use App\Models\Catalogs\SatProductStcc;
use App\Models\Catalogs\TariffFraction;
use Illuminate\Database\Eloquent\Model;
use App\Models\Catalogs\DangerousProduct;
use App\Models\Catalogs\TrailerType;
use Hyn\Tenancy\Traits\UsesTenantConnection;

/**
 * App\Models\Sales\CustomerInvoiceLineTransfer
 *
 * @property int $id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $created_uid
 * @property int|null $updated_uid
 * @property int $customer_invoice_id
 * @property string $name
 * @property int|null $product_id
 * @property string|null $weight
 * @property float $m3
 * @property float $liters
 * @property string|null $packaging
 * @property int $sort_order
 * @property bool $status
 * @property-read \App\Models\Sales\CustomerInvoice $customerInvoice
 * @property-read \App\Models\Catalogs\Product|null $product
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer filter($input = array())
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer sortable($defaultParameters = null)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereCreatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereCustomerInvoiceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereLiters($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereM3($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer wherePackaging($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereProductId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereSortOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereUpdatedUid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sales\CustomerInvoiceLineTransfer whereWeight($value)
 * @mixin \Eloquent
 */
class CustomerInvoiceLineTransfer extends Model
{
    use Sortable,UsesTenantConnection;

    protected $table = 'customer_invoice_line_transfers';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'created_uid',
        'updated_uid',
        'customer_invoice_id',
        'name',
        'product_id',
        'weight',
        'm3',
        'liters',
        'packaging',
        'sort_order',
        'status',
        'sat_product_id',
        'sat_product_stcc_id',
        'quantity',
        'unit_measure_id',
        'dimensions',
        'dangerous_product',
        'dangerous_product_id',
        'packaging_type_id',
        'amount_total',
        'currency_id',
        'tariff_fraction_id',
        'uuid_ext',
        'petition'
    ];

    /**
     * Sortable columns.
     *
     * @var array
     */
    public $sortable = ['name','sort_order', 'status'];

    public function scopeFilter($query, array $input = [])
    {
        if (!empty($input['filter_search'])) {
            $search = $input['filter_search'];
            $query->orWhere('name', 'like', '%' . str_replace(' ', '%%', $search) . '%');
        }
        return $query;
    }

    public function scopeActive($query)
    {
        $query->where('status','=','1');

        return $query;
    }

    public function customerInvoice()
    {
        return $this->belongsTo(CustomerInvoice::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unitMeasure()
    {
        return $this->belongsTo(UnitMeasure::class);
    }

    public function satProduct()
    {
        return $this->belongsTo(SatProduct::class);
    }

    public function satProductStcc()
    {
        return $this->belongsTo(SatProductStcc::class);
    }

    public function dangerousProduct()
    {
        return $this->belongsTo(DangerousProduct::class);
    }

    public function packagingType()
    {
        return $this->belongsTo(PackagingType::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function tariffFraction()
    {
        return $this->belongsTo(TariffFraction::class);
    }

}
